/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.synth.SynthContext;

public class SliderPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SliderPainter";

    protected SliderPainter() {
    }

    public static SliderPainter getInstance() {
        return SliderPainter.getInstance(null);
    }

    public static SliderPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(SliderPainter.getPainterClassName(synthContext, SliderPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = SliderPainter.getInstance(synthContext, SliderPainter.class, UI_KEY);
        }
        return (SliderPainter)syntheticaComponentPainter;
    }

    public void paintSliderBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.hasFocus()) {
            FocusPainter.paintFocus("focus.slider", synthContext, graphics, n2, n3, n4, n5);
        }
    }

    public void paintSliderBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintSliderTrackBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JSlider jSlider = (JSlider)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        this.paintSliderTrack(jSlider, syntheticaPainterState, jSlider.getOrientation(), graphics, n2, n3, n4, n5);
        syntheticaPainterState = new SyntheticaPainterState(synthContext, 0, true);
        this.paintSliderTrack(jSlider, syntheticaPainterState, jSlider.getOrientation(), jSlider.getValue(), jSlider.getMinimum(), jSlider.getMaximum(), jSlider.getInverted(), graphics, n2, n3, n4, n5);
    }

    public void paintSliderTrack(JComponent jComponent, SyntheticaState syntheticaState, int n2, Graphics graphics, int n3, int n4, int n5, int n6) {
        Insets insets;
        UIKey uIKey = new UIKey("slider.track", syntheticaState, -1, -1, n2);
        Insets insets2 = insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "image.insets", true, 1);
        String string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        ImagePainter imagePainter = new ImagePainter(jComponent, graphics, n3, n4, n5, n6, string, insets, insets2, 0, 0);
        imagePainter.draw();
    }

    public void paintSliderTrack(JComponent jComponent, SyntheticaState syntheticaState, int n2, int n3, int n4, int n5, boolean bl, Graphics graphics, int n6, int n7, int n8, int n9) {
        String string = "slider.trackMark";
        UIKey uIKey = new UIKey(string, syntheticaState, -1, -1, n2);
        String string2 = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        if (string2 == null) {
            string = "slider.track";
            uIKey = new UIKey(string, syntheticaState, -1, -1, n2);
            string2 = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        }
        if (string2 != null) {
            int n10;
            boolean bl2;
            Insets insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "image.insets", true, 1);
            Insets insets2 = (Insets)insets.clone();
            uIKey = new UIKey(string, syntheticaState);
            int n11 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jComponent, 1);
            int n12 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jComponent, 50);
            int n13 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 2);
            if (syntheticaState.isSet(SyntheticaState.State.HOVER) || syntheticaState.isSet(SyntheticaState.State.PRESSED)) {
                n13 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 1);
            }
            int n14 = n3 - n4;
            int n15 = n5 == n4 ? n14 : n5 - n4;
            boolean bl3 = bl2 = jComponent.isEnabled() && this.isSliderTrackMarkEnabled(jComponent);
            if (n15 == 0) {
                n15 = 1;
            }
            if (n2 == 0) {
                n10 = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbWidth", jComponent, SyntheticaLookAndFeel.getInt("Synthetica.slider.thumb.width", jComponent, 10));
                int n16 = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbX", jComponent, 0);
                n8 -= n10;
                if (!bl ^ !jComponent.getComponentOrientation().isLeftToRight()) {
                    n8 = bl2 ? n16 - n6 + n10 / 2 : n8 * n14 / n15 + n10 / 2;
                    insets2.right = 0;
                } else {
                    int n17 = bl2 ? n8 + n6 - n16 + n10 / 2 : n8 * n14 / n15 + n10 / 2;
                    n6 += n8 - n17 + n10;
                    n8 = n17;
                    insets2.left = 0;
                }
            } else {
                n10 = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbHeight", jComponent, SyntheticaLookAndFeel.getInt("Synthetica.slider.thumb.width", jComponent, 10));
                int n18 = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbY", jComponent, 0);
                n9 -= n10;
                if (!bl) {
                    int n19 = bl2 ? n9 + n7 - n18 + n10 / 2 : n9 * n14 / n15 + n10 / 2;
                    n7 += n9 - n19 + n10;
                    n9 = n19;
                    insets2.top = 0;
                } else {
                    n9 = bl2 ? n18 - n7 + n10 / 2 : n9 * n14 / n15 + n10 / 2;
                    insets2.bottom = 0;
                }
            }
            ImagePainter imagePainter = new ImagePainter(jComponent, "track", n11, n12, n13, syntheticaState.getState(), graphics, n6, n7, n8, n9, string2, insets, insets2, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintSliderThumbBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
    }

    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        JSlider jSlider = (JSlider)synthContext.getComponent();
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        this.paintSliderThumb(jSlider, syntheticaPainterState, n6, graphics, n2, n3, n4, n5);
    }

    public void paintSliderThumb(JComponent jComponent, SyntheticaState syntheticaState, int n2, Graphics graphics, int n3, int n4, int n5, int n6) {
        Insets insets;
        if (this.isSliderTrackMarkEnabled(jComponent)) {
            int n7 = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbX", jComponent, -1);
            int n8 = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbY", jComponent, -1);
            if (n7 != n3 || n8 != n4) {
                jComponent.putClientProperty("Synthetica.thumbX", n3);
                jComponent.putClientProperty("Synthetica.thumbY", n4);
                jComponent.putClientProperty("Synthetica.thumbWidth", n5);
                jComponent.putClientProperty("Synthetica.thumbHeight", n6);
                jComponent.repaint();
            }
        }
        UIKey uIKey = new UIKey("slider.thumb", syntheticaState, -1, -1, n2);
        Insets insets2 = insets = (Insets)UIKey.findProperty(jComponent, uIKey.get(), "image.insets", true, 1);
        String string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        if (syntheticaState.isSet(SyntheticaState.State.PRESSED) && string == null) {
            syntheticaState.setState(SyntheticaState.State.HOVER.toInt());
            uIKey = new UIKey("slider.thumb", syntheticaState, -1, -1, n2);
            string = SyntheticaLookAndFeel.getString(uIKey.get("image"), jComponent);
        }
        if (string != null) {
            uIKey = new UIKey("slider.thumb", syntheticaState);
            int n9 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), jComponent, 1);
            int n10 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), jComponent, 50);
            int n11 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 2);
            if (syntheticaState.isSet(SyntheticaState.State.HOVER) || syntheticaState.isSet(SyntheticaState.State.PRESSED)) {
                n11 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), jComponent, 1);
            }
            ImagePainter imagePainter = new ImagePainter(jComponent, "thumb", n9, n10, n11, syntheticaState.getState(), graphics, n3, n4, n5, n6, string, insets, insets2, 0, 0);
            imagePainter.draw();
        }
        if (jComponent.hasFocus() || syntheticaState.isSet(SyntheticaState.State.FOCUSED)) {
            String string2 = null;
            if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb.x", jComponent) != null && ((JSlider)jComponent).getOrientation() == 0) {
                string2 = "focus.slider.thumb.x";
            } else if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb.y", jComponent) != null && ((JSlider)jComponent).getOrientation() == 1) {
                string2 = "focus.slider.thumb.y";
            } else if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb", jComponent) != null) {
                string2 = "focus.slider.thumb";
            }
            if (string2 != null) {
                FocusPainter.paintFocus(string2, jComponent, syntheticaState.getState(), "", graphics, n3, n4, n5, n6);
            }
        }
    }

    private boolean isSliderTrackMarkEnabled(JComponent jComponent) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.slider.hoverAndPressed.enabled", jComponent, false) || SyntheticaLookAndFeel.getBoolean("Synthetica.slider.trackMark.enabled", jComponent, false);
    }

    public int getCacheHash(SynthContext synthContext, int n2, int n3, int n4, String string) {
        if (string.equals("paintSliderBackground")) {
            return -1;
        }
        JSlider jSlider = (JSlider)synthContext.getComponent();
        int n5 = jSlider.getOrientation();
        int n6 = super.getCacheHash(synthContext, n2, n3, n4, string);
        n6 = 31 * n6 + n5;
        return n6;
    }
}

